//
//  MCWebKitTemplateView.h
//  MCApplication
//
//  Created by Ali Lalani on 30/03/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <WebKit/WebKit.h>

// Defines for the bindings - they define indices into the various C style arrays for keeping track of the necessary things
#define   MCWebKitTemplateViewBindingCount          1
#define   MCWebKitTemplateViewModelBinding       0x00
//... define more as necessary

@class MCWebViewTemplate,MCGenericPlaceholderView;
@interface MCWebKitTemplateView : NSView {
	WebView *webView;
		
	id model;
	id document;
	id delegate; // not retained
	
	NSString *_extension;
	NSString *_identifier;

	MCWebViewTemplate *_webViewTemplate;
	
	NSArray *templateMenuItems;

	MCGenericPlaceholderView *_placeholderView;
    
	BOOL _drawsBorders;

	// if this is YES, processTemplate won't do anything but as soon as the view enters a window it will call processTemplate
	BOOL _deferProcessTemplate;
	
	// If this is yes, then before the model is set it will be asked to refreshIfNeeded
	BOOL _shouldCheckForRefreshOnModel;
	
	BOOL _disableInlineActions; // if you don't want any actions to be allowed in the view(i.e. clicking on a contact name and the contact card coming up), set this to YES
    // Binding Support
	id          __observedObjects[MCWebKitTemplateViewBindingCount];
	NSString*   __observedKeyPaths[MCWebKitTemplateViewBindingCount];
    
	BOOL _reprocessesOnModelChanges;
}
- (void)commonInit;
- (void)configureFromDictionary:(NSDictionary *)conf;

// Constructs the merge pack, subclassers can override this to add more stuff
- (NSMutableDictionary *)mergePack;

- (NSString *)processTemplate;
- (void)clearTemplate;

- (void)performActionForURLDictionary:(NSDictionary *)dict;

- (IBAction)switchToTemplate:(id)sender;

- (id)model;
- (NSString *)processModel:(id)aModel workWithMultiples:(BOOL)multiples;
- (void)setModel:(id)aModel;

- (id)document;
- (void)setDocument:(id)aDocument;

- (void)setDelegate:(id)aDeleg;
- (id)delegate;

- (MCWebViewTemplate *)webViewTemplate;
- (void)setWebViewTemplateNoRegistration:(MCWebViewTemplate *)aWebViewTemplate;
- (void)setWebViewTemplate:(MCWebViewTemplate *)aWebViewTemplate;

- (NSString *)extension;
- (void)setExtension:(NSString *)anExtension;

- (NSString *)identifier;
- (void)setIdentifier:(NSString *)anIdentifier;

- (NSString *)appName;

- (NSArray *)templateMenuItems;
- (void)setTemplateMenuItems:(NSArray *)aTemplateMenuItems;

- (WebView *)webView;
- (void)setWebView:(WebView *)aWebView;

- (MCGenericPlaceholderView *)placeholderView;
- (void)setPlaceholderView:(MCGenericPlaceholderView *)aPlaceholderView;

- (BOOL)drawsBorders;
- (void)setDrawsBorders:(BOOL)flag;

// For binding support
- (void)_setObservedObject: (id)observable forIndex: (int)index;
- (void)_setObservedKeyPath: (NSString*)keyPath forIndex: (int)index;

- (BOOL)shouldCheckForRefreshOnModel;
- (void)setShouldCheckForRefreshOnModel:(BOOL)flag;

- (BOOL)disableInlineActions;
- (void)setDisableInlineActions:(BOOL)flag;

- (BOOL)reprocessesOnModelChanges;
- (void)setReprocessesOnModelChanges:(BOOL)flag;

#pragma mark JavascriptControllerMethods
- (BOOL)runFScriptAtPath:(NSString *)path;
- (BOOL)runFScriptWithName:(NSString *)path;

@end

@interface NSObject (MCWebKitTemplateViewDelegate)
/* Gives the delegate the opportunity to add keys to the merge pack. The delegate may replace keys, but it 
should not remove them.

document
objectContext
model

are required keys

*/
- (void)webkitTemplateView:(MCWebKitTemplateView *)aTemplateView 
	 isAboutToUseMergePack:(NSMutableDictionary *)aMergePack;
@end
